/*
 * Decompiled with CFR 0.152.
 */
package net.endil.farmersutils.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.endil.farmersutils.common.registry.FUBlocks;
import net.endil.farmersutils.common.registry.FURecipeSerializers;
import net.endil.farmersutils.common.registry.FURecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DryingRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int dryingTime;

    public DryingRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, int dryingTime) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.dryingTime = dryingTime;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.ingredient.test(pContainer.m_8020_(0));
    }

    public ItemStack m_5874_(Container pContainer) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FURecipeSerializers.DRYING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FURecipeTypes.DRYING.get();
    }

    public int getDryingTime() {
        return this.dryingTime;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)FUBlocks.DRYING_RACK.get());
    }

    public static class Serializer
    implements RecipeSerializer<DryingRecipe> {
        public DryingRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            int dryingTime = GsonHelper.m_13927_((JsonObject)json, (String)"dryingtime");
            return new DryingRecipe(id, ingredient, result, dryingTime);
        }

        @Nullable
        public DryingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack result = pBuffer.m_130267_();
            int dryingTime = pBuffer.m_130242_();
            return new DryingRecipe(id, ingredient, result, dryingTime);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, DryingRecipe pRecipe) {
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.m_130130_(pRecipe.dryingTime);
        }
    }
}

